#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_container_node.h>

namespace NInfra::NPodAgent {

class TFeedbackContainerDeathTimeNode;
using TFeedbackContainerDeathTimeNodePtr = TSimpleSharedPtr<TFeedbackContainerDeathTimeNode>;

class TFeedbackContainerDeathTimeNode : public TPortoBasicContainerNode<TString> {
public:
    TFeedbackContainerDeathTimeNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , TAsyncPortoClientPtr porto
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
    )
        : TPortoBasicContainerNode(descriptor, porto, containerStatusRepository, container, containerName)
    {}

    virtual ENodeType GetType() const override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_CONTAINER_DEATH_TIME;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResultSuccess(TTickContextPtr context, TString& result) override final;
};

} // namespace NInfra::NPodAgent
