#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_container_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackContainerFailReasonNode;
using TFeedbackContainerFailReasonNodePtr = TSimpleSharedPtr<TFeedbackContainerFailReasonNode>;

class TFeedbackContainerFailReasonNode : public TFeedbackContainerBasicNode {
public:
    TFeedbackContainerFailReasonNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepotisoty
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TString& failReason
    )
        : TFeedbackContainerBasicNode(descriptor, containerStatusRepotisoty, container)
        , FailReason_(failReason)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_CONTAINER_FAIL_REASON;

private:
    const TString FailReason_;
};

} // namespace NInfra::NPodAgent
