#include "feedback_container_fail_reason_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestFeedbackContainerFailReasonNode {

static TLogger logger({});

class TFeedbackWorkloadContainerBaseTestCase: public NUnitTest::TBaseTestCase {
public:
    TFeedbackWorkloadContainerBaseTestCase()
        : Holder_(new TWorkloadStatusRepository())
        , WorkloadId_("my_workload")
    {
        Holder_->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(WorkloadId_));
    }

    void TestUpdateFailReason() {
        TFeedbackContainerFailReasonNodePtr node = CreateNode();
        auto result = node->Tick(MockTickContext(logger));
        UNIT_ASSERT_C(result, result.Error().Message);
        UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
        auto status = Holder_->GetObjectStatus(WorkloadId_);
        UNIT_ASSERT_EQUAL(FailReason_, GetContainerStatus(status).current().fail_reason());
    }

private:
    virtual NStatusRepositoryTypes::TContainerDescription::EContainerType GetContainerType() const = 0;
    virtual API::TContainerStatus GetContainerStatus(const API::TWorkloadStatus& status) const = 0;

    TFeedbackContainerFailReasonNodePtr CreateNode() {
        return new TFeedbackContainerFailReasonNode(
            TBasicTreeNodeDescriptor{1, "title"}
            , Holder_
            , NStatusRepositoryTypes::TContainerDescription(
                WorkloadId_
                , NStatusRepositoryTypes::EObjectType::WORKLOAD
                , GetContainerType()
            )
            , FailReason_
        );
    }

public:
    TWorkloadStatusRepositoryPtr Holder_;
    const TString WorkloadId_;
    const TString FailReason_ = "This is fail reason";
};

class TFeedbackWorkloadContainerReadinessTestCase: public TFeedbackWorkloadContainerBaseTestCase {
private:
    NStatusRepositoryTypes::TContainerDescription::EContainerType
    GetContainerType() const override {
        return NStatusRepositoryTypes::TContainerDescription::EContainerType::READINESS;
    }

    API::TContainerStatus GetContainerStatus(const API::TWorkloadStatus& status) const override {
        return status.readiness_status().container_status();
    }
};

class TFeedbackWorkloadContainerLivenessTestCase: public TFeedbackWorkloadContainerBaseTestCase {
private:
    NStatusRepositoryTypes::TContainerDescription::EContainerType
    GetContainerType() const override {
        return NStatusRepositoryTypes::TContainerDescription::EContainerType::LIVENESS;
    }

    API::TContainerStatus GetContainerStatus(const API::TWorkloadStatus& status) const override {
        return status.liveness_status().container_status();
    }
};

class TFeedbackWorkloadContainerStartTestCase: public TFeedbackWorkloadContainerBaseTestCase {
private:
    NStatusRepositoryTypes::TContainerDescription::EContainerType
    GetContainerType() const override {
        return NStatusRepositoryTypes::TContainerDescription::EContainerType::START;
    }

    API::TContainerStatus GetContainerStatus(const API::TWorkloadStatus& status) const override {
        return status.start();
    }
};

class TFeedbackWorkloadContainerStopTestCase: public TFeedbackWorkloadContainerBaseTestCase {
private:
    NStatusRepositoryTypes::TContainerDescription::EContainerType
    GetContainerType() const override {
        return NStatusRepositoryTypes::TContainerDescription::EContainerType::STOP;
    }

    API::TContainerStatus GetContainerStatus(const API::TWorkloadStatus& status) const override {
        return status.stop_status().container_status();
    }
};

Y_UNIT_TEST_SUITE_F(FeedbackWorkloadContainerReadinessFailReasonNodeSuite, TFeedbackWorkloadContainerReadinessTestCase) {

Y_UNIT_TEST(TestUpdateFailReason) {
    TestUpdateFailReason();
}

}

Y_UNIT_TEST_SUITE_F(FeedbackWorkloadContainerLivenessFailReasonNodeSuite, TFeedbackWorkloadContainerLivenessTestCase) {

Y_UNIT_TEST(TestUpdateFailReason) {
    TestUpdateFailReason();
}

}

Y_UNIT_TEST_SUITE_F(FeedbackWorkloadContainerStartFailReasonNodeSuite, TFeedbackWorkloadContainerStartTestCase) {

Y_UNIT_TEST(TestUpdateFailReason) {
    TestUpdateFailReason();
}

}

Y_UNIT_TEST_SUITE_F(FeedbackWorkloadContainerStopFailReasonNodeSuite, TFeedbackWorkloadContainerStopTestCase) {

Y_UNIT_TEST(TestUpdateFailReason) {
    TestUpdateFailReason();
}

}

} // namespace NInfra::NPodAgent::NTestFeedbackContainerFailReasonNode
