#include "feedback_container_owner_state_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackContainerOwnerStateNode::GetType() const {
    return TFeedbackContainerOwnerStateNode::NODE_TYPE;
}

TTickResult TFeedbackContainerOwnerStateNode::TickImpl(TTickContextPtr context) {
    auto oldState = ContainerStatusRepository_->UpdateContainerOwnerState(Container_, State_);

    if (State_ != oldState) {
        NLogEvent::TObjectStateUpdate event;

        const auto ids = ContainerStatusRepository_->GetObjectIdsByHash(Container_.ObjectIdOrHash_);
        for (const auto& id : ids) {
            *(event.add_ids()) = id;
        }

        const auto cacheObjects = ContainerStatusRepository_->GetCacheObjectIdsAndRevisionsByHash(Container_.ObjectIdOrHash_);
        for (const auto& cacheObject : cacheObjects) {
            *(event.add_cacheobjects()) = NLogEvent::TPodAgentCacheObject(
                cacheObject.Id_
                , cacheObject.Revision_
            );
        }

        event.set_objectidorhash(Container_.ObjectIdOrHash_);
        event.set_oldstate(GetStringFromState(oldState));
        event.set_newstate(GetStringFromState(State_));
        event.set_objecttype(GetObjectTypeFromEnum(ContainerStatusRepository_->GetObjectType()));
        context.Get()->LogFrame.Get()->LogEvent(event);
    }

    return TNodeSuccess(ENodeStatus::SUCCESS);
}

} // namespace NInfra::NPodAgent
