#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/common.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_container_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackContainerOwnerStateNode;
using TFeedbackContainerOwnerStateNodePtr = TSimpleSharedPtr<TFeedbackContainerOwnerStateNode>;

class TFeedbackContainerOwnerStateNode : public TFeedbackContainerBasicNode {
public:
    TFeedbackContainerOwnerStateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TStatusRepositoryCommon::TObjectState& state
    )
        : TFeedbackContainerBasicNode(descriptor, containerStatusRepository, container)
        , State_(state)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_CONTAINER_OWNER_STATE;

private:
    const TStatusRepositoryCommon::TObjectState State_;
};

} // namespace NInfra::NPodAgent
