#include "feedback_container_owner_state_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestFeedbackContainerOwnerStateNode {

Y_UNIT_TEST_SUITE(FeedbackContainerOwnerStateNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestUpdateStateWithReadinessHook) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));
    API::EWorkloadState state = API::EWorkloadState_ACTIVE;
    TFeedbackContainerOwnerStateNodePtr node = new TFeedbackContainerOwnerStateNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , NStatusRepositoryTypes::TContainerDescription(
            id
            , NStatusRepositoryTypes::EObjectType::WORKLOAD
            , NStatusRepositoryTypes::TContainerDescription::EContainerType::READINESS
        )
        , TStatusRepositoryCommon::TObjectState(state)
    );
    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
    API::TWorkloadStatus status = holder->GetObjectStatus(id);
    UNIT_ASSERT_EQUAL(state, status.state());
}

Y_UNIT_TEST(TestUpdateStateWithLivenessHook) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));
    API::EWorkloadState state = API::EWorkloadState_ACTIVE;
    TFeedbackContainerOwnerStateNodePtr node = new TFeedbackContainerOwnerStateNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , NStatusRepositoryTypes::TContainerDescription(
            id
            , NStatusRepositoryTypes::EObjectType::WORKLOAD
            , NStatusRepositoryTypes::TContainerDescription::EContainerType::LIVENESS
        )
        , TWorkloadStatusRepository::TObjectState(state)
    );
    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
    API::TWorkloadStatus status = holder->GetObjectStatus(id);
    UNIT_ASSERT_EQUAL(state, status.state());
}

}

} // namespace NInfra::NPodAgent::NTestFeedbackContainerOwnerStateNode
