#include "feedback_container_start_time_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackContainerStartTimeNode::GetType() const {
    return TFeedbackContainerStartTimeNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TFeedbackContainerStartTimeNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(ContainerName_, EPortoContainerProperty::StartTimeRaw);
}

TTickResult TFeedbackContainerStartTimeNode::ProcessPortoResultSuccess(TTickContextPtr /*context*/, TString& result) {
    try {
        ContainerStatusRepository_->UpdateContainerStartTime(Container_, TInstant::Seconds(FromString<time_t>(result)));

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
