#include "feedback_container_state_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackContainerStateNode::GetType() const {
    return TFeedbackContainerStateNode::NODE_TYPE;
}

TTickResult TFeedbackContainerStateNode::TickImpl(TTickContextPtr /*context*/) {
    ContainerStatusRepository_->UpdateContainerState(Container_, State_);
    if (State_ == API::EContainerState_TIMEOUT) {
        ContainerStatusRepository_->IncrementContainerTimeoutCounter(Container_);
    }

    // Do not increment SystemFailureCounter because porto/posix nodes do it instead

    return TNodeSuccess(ENodeStatus::SUCCESS);
}

} // namespace NInfra::NPodAgent
