#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_container_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackContainerStateNode;
using TFeedbackContainerStateNodePtr = TSimpleSharedPtr<TFeedbackContainerStateNode>;

class TFeedbackContainerStateNode : public TFeedbackContainerBasicNode  {
public:
    TFeedbackContainerStateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , API::EContainerState state
    )
        : TFeedbackContainerBasicNode(descriptor, containerStatusRepository, container)
        , State_(state)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_CONTAINER_STATE;

private:
    const API::EContainerState State_;
};

} // namespace NInfra::NPodAgent
