#include "feedback_container_status_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackContainerStatusNode::GetType() const {
    return TFeedbackContainerStatusNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TFeedbackContainerStatusNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(ContainerName_, EPortoContainerProperty::ExitCode);
}

TTickResult TFeedbackContainerStatusNode::ProcessPortoResultSuccess(TTickContextPtr /*context*/, TString& result) {
    try {
        int exitCode = FromString(result);
        ContainerStatusRepository_->UpdateContainerReturnCode(Container_, exitCode);
        ContainerStatusRepository_->UpdateContainerConsecutiveFailuresAndSuccessesCounter(Container_, exitCode);

        if (exitCode == -99) {
            ContainerStatusRepository_->UpdateContainerState(Container_, API::EContainerState_OUT_OF_MEMORY);
            ContainerStatusRepository_->IncrementContainerOomCounter(Container_);
        } else if (exitCode == 0) {
            ContainerStatusRepository_->UpdateContainerState(Container_, API::EContainerState_EXITED);
            ContainerStatusRepository_->IncrementContainerZeroReturnCodeCounter(Container_);
        } else if (exitCode > 0) {
            ContainerStatusRepository_->UpdateContainerState(Container_, API::EContainerState_EXITED);
            ContainerStatusRepository_->IncrementContainerPositiveReturnCodeCounter(Container_);
        } else if (exitCode < 0) {
            ContainerStatusRepository_->UpdateContainerState(Container_, API::EContainerState_KILLED_EXTERNALLY);
            ContainerStatusRepository_->IncrementContainerKilledExternallyCounter(Container_);
        } else {
            ythrow yexception() << "This case must be unreachable";
        }

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
