#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_container_node.h>

namespace NInfra::NPodAgent {

class TFeedbackContainerStatusNode;
using TFeedbackContainerStatusNodePtr = TSimpleSharedPtr<TFeedbackContainerStatusNode>;

class TFeedbackContainerStatusNode : public TPortoBasicContainerNode<TString> {
public:
    TFeedbackContainerStatusNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , TAsyncPortoClientPtr porto
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
    )
        : TPortoBasicContainerNode(descriptor, porto, containerStatusRepository, container, containerName)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResultSuccess(TTickContextPtr context, TString& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_CONTAINER_STATUS;
};

} // namespace NInfra::NPodAgent
