#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_container_stream_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackContainerStdoutNode;
using TFeedbackContainerStdoutNodePtr = TSimpleSharedPtr<TFeedbackContainerStdoutNode>;

class TFeedbackContainerStdoutNode : public TFeedbackContainerStreamBasicNode {
public:
    TFeedbackContainerStdoutNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , TAsyncPortoClientPtr porto
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
    )
        : TFeedbackContainerStreamBasicNode(
            descriptor
            , containerStatusRepository
            , porto
            , container
            , containerName
            , EContainerField::Stdout
        )
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual void UpdateWorkloadContainerStatus(const TString& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_CONTAINER_STDOUT;
};

} // namespace NInfra::NPodAgent
