#include "feedback_object_check_failed_message_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackObjectCheckFailedMessageNode::GetType() const {
    return TFeedbackObjectCheckFailedMessageNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TFeedbackObjectCheckFailedMessageNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(ContainerName_, ContainerProperty_);
}

TTickResult TFeedbackObjectCheckFailedMessageNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (result) {
        TStringBuilder finalFailedMessage;
        finalFailedMessage << "verify bad hash, expected '" << Ref_ << "', got '" << result.Success() << "'";
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, finalFailedMessage.copy());
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeError({TStringBuilder() << ToString(result.Error().Code) << ":" << result.Error().Action << ":" << result.Error().Message});
    }
}

} // namespace NInfra::NPodAgent
