#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TFeedbackObjectCheckFailedMessageNode;
using TFeedbackObjectCheckFailedMessageNodePtr = TSimpleSharedPtr<TFeedbackObjectCheckFailedMessageNode>;

class TFeedbackObjectCheckFailedMessageNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TFeedbackObjectCheckFailedMessageNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , TAsyncPortoClientPtr porto
        , const TString& objectIdOrHash
        , const TPortoContainerName& containerName
        , EPortoContainerProperty containerProperty
        , const TString& ref
    )
        : TPortoBasicNode(descriptor, porto)
        , ObjectIdOrHash_(objectIdOrHash)
        , ContainerName_(containerName)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ContainerProperty_(containerProperty)
        , Ref_(ref)
    {
        Y_ENSURE(StatusRepositoryCommon_, "StatusRepositoryCommon not defined for TFeedbackObjectCheckFailedMessageNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_OBJECT_CHECK_FAILED_MESSAGE;

private:
    const TString ObjectIdOrHash_;
    const TPortoContainerName ContainerName_;
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const EPortoContainerProperty ContainerProperty_;
    const TString Ref_;
};

} // namespace NInfra::NPodAgent
