#include "feedback_object_download_attempt_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackObjectDownloadAttemptNode::GetType() const {
    return TFeedbackObjectDownloadAttemptNode::NODE_TYPE;
}

TTickResult TFeedbackObjectDownloadAttemptNode::TickImpl(TTickContextPtr /*context*/) {
    try {
        StatusRepositoryCommon_->UpdateObjectDownloadAttempt(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
