#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_object_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackObjectDownloadAttemptNode;
using TFeedbackObjectDownloadAttemptNodePtr = TSimpleSharedPtr<TFeedbackObjectDownloadAttemptNode>;

class TFeedbackObjectDownloadAttemptNode : public TFeedbackObjectBasicNode {
public:
    TFeedbackObjectDownloadAttemptNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
    )
        : TFeedbackObjectBasicNode(descriptor, statusRepositoryCommon, objectIdOrHash)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_OBJECT_DOWNLOAD_ATTEMPT;
};

} // namespace NInfra::NPodAgent
