#include "feedback_object_download_complete_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackObjectDownloadCompleteNode::GetType() const {
    return TFeedbackObjectDownloadCompleteNode::NODE_TYPE;
}

TTickResult TFeedbackObjectDownloadCompleteNode::TickImpl(TTickContextPtr /*context*/) {
    try {
        StatusRepositoryCommon_->UpdateObjectDownloadProgress(ObjectIdOrHash_, 100);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
