#include "feedback_object_download_complete_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/layer_status_repository.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NFeedbackObjectDownloadCompleteNodeTest {

static TLogger logger({});

Y_UNIT_TEST_SUITE(FeedbackObjectDownloadCompleteNodeSuite) {

Y_UNIT_TEST(TestDownloadComplete) {
    TLayerStatusRepositoryPtr holder = new TLayerStatusRepository();
    const TString id = "my_layer";
    const TString hash = "my_layer_download_hash";

    holder->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple(id, hash));

    TFeedbackObjectDownloadCompleteNodePtr node = new TFeedbackObjectDownloadCompleteNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , hash
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
    API::TLayerStatus status = holder->GetObjectStatus(id, nullptr);
    UNIT_ASSERT_EQUAL(status.download_progress().percent(), 100);
}

Y_UNIT_TEST(TestDownloadCompleteWithError) {
    TLayerStatusRepositoryPtr holder = new TLayerStatusRepository();
    const TString id = "my_layer";
    const TString hash = "my_layer_download_hash";

    TFeedbackObjectDownloadCompleteNodePtr node = new TFeedbackObjectDownloadCompleteNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , hash
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(!result, result.Success().Status);
    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "not found");
}

}

} // namespace NInfra::NPodAgent::NFeedbackObjectDownloadCompleteNodeTest
