#include "feedback_object_failed_message_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackObjectFailedMessageNode::GetType() const {
    return TFeedbackObjectFailedMessageNode::NODE_TYPE;
}

TTickResult TFeedbackObjectFailedMessageNode::TickImpl(TTickContextPtr /*context*/) {
    try {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, FailedMessage_);
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
