#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_object_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackObjectFailedMessageNode;
using TFeedbackObjectFailedMessageNodePtr = TSimpleSharedPtr<TFeedbackObjectFailedMessageNode>;

class TFeedbackObjectFailedMessageNode : public TFeedbackObjectBasicNode {
public:
    TFeedbackObjectFailedMessageNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , const TString& failedMessage
    )
        : TFeedbackObjectBasicNode(descriptor, statusRepositoryCommon, objectIdOrHash)
        , FailedMessage_(failedMessage)
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_OBJECT_FAILED_MESSAGE;

private:
    const TString FailedMessage_;
};

} // namespace NInfra::NPodAgent
