#include "feedback_object_failed_message_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/layer_status_repository.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestFeedbackObjectFailedMessageNode {

static TLogger logger({});

Y_UNIT_TEST_SUITE(FeedbackObjectFailedMessageNodeSuite) {

Y_UNIT_TEST(TestUpdateFailedMessage) {
    TLayerStatusRepositoryPtr holder = new TLayerStatusRepository();
    const TString id = "my_layer";
    const TString hash = "my_layer_download_hash";

    holder->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple(id, hash));

    const TString message = "my_message";
    TFeedbackObjectFailedMessageNodePtr node = new TFeedbackObjectFailedMessageNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , hash
        , message
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, result.Success().Status);

    API::TLayerStatus status = holder->GetObjectStatus(id);
    UNIT_ASSERT_EQUAL_C(message, status.failed().message(), message);
    UNIT_ASSERT_EQUAL(status.fail_counter(), 1);
}

Y_UNIT_TEST(TestUpdateFailedMessageWithError) {
    TLayerStatusRepositoryPtr holder = new TLayerStatusRepository();
    const TString hash = "my_layer_download_hash";

    const TString message = "my_message";
    TFeedbackObjectFailedMessageNodePtr node = new TFeedbackObjectFailedMessageNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , hash
        , message
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(!result, result.Success().Status);
    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "not found");
}

}

} // namespace NInfra::NPodAgent::NTestFeedbackObjectFailedMessageNode
