#include "feedback_object_ip_address_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackObjectIpAddressNode::GetType() const {
    return TFeedbackObjectIpAddressNode::NODE_TYPE;
}

TTickResult TFeedbackObjectIpAddressNode::TickImpl(TTickContextPtr /*context*/) {
    try {
        StatusRepositoryCommon_->UpdateObjectIpAddress(ObjectIdOrHash_, Address_);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
