#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_object_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackObjectIpAddressNode;
using TFeedbackObjectIpAddressNodePtr = TSimpleSharedPtr<TFeedbackObjectIpAddressNode>;

class TFeedbackObjectIpAddressNode : public TFeedbackObjectBasicNode {
public:
    TFeedbackObjectIpAddressNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , const TString& address
    )
        : TFeedbackObjectBasicNode(descriptor, statusRepositoryCommon, objectIdOrHash)
        , Address_(address)
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_OBJECT_IP_ADDRESS;

private:
    const TString Address_;
};

} // namespace NInfra::NPodAgent
