#include "feedback_object_ip_address_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/box_status_repository.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestFeedbackObjectIpAddressNode {

static TLogger logger({});

Y_UNIT_TEST_SUITE(FeedbackObjectIpAddressNodeSuite) {

Y_UNIT_TEST(TestUpdateIpAddress) {
    TBoxStatusRepositoryPtr holder = new TBoxStatusRepository();
    const TString id = "my_box";

    holder->AddObject(NObjectMetaTestLib::CreateBoxMetaSimple(id));

    const TString address = "my_address";
    TFeedbackObjectIpAddressNodePtr node = new TFeedbackObjectIpAddressNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
        , address
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, result.Success().Status);

    API::TBoxStatus status = holder->GetObjectStatus(id);
    UNIT_ASSERT_EQUAL_C(address, status.ip6_address(), address);
}

Y_UNIT_TEST(TestUpdateIpAddressWithError) {
    TBoxStatusRepositoryPtr holder = new TBoxStatusRepository();
    const TString id = "my_box";

    const TString address = "my_address";
    TFeedbackObjectIpAddressNodePtr node = new TFeedbackObjectIpAddressNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
        , address
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(!result, result.Success().Status);
    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "not found");
}

}

} // namespace NInfra::NPodAgent::NTestFeedbackObjectIpAddressNode
