#include "feedback_object_state_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackObjectStateNode::GetType() const {
    return TFeedbackObjectStateNode::NODE_TYPE;
}

TTickResult TFeedbackObjectStateNode::TickImpl(TTickContextPtr context) {
    try {
        auto oldState = StatusRepositoryCommon_->UpdateObjectState(ObjectIdOrHash_, State_);

        if (oldState != State_) {
            NLogEvent::TObjectStateUpdate event;

            auto ids = StatusRepositoryCommon_->GetObjectIdsByHash(ObjectIdOrHash_);
            for (const auto& id : ids) {
                *(event.add_ids()) = id;
            }

            const auto cacheObjects = StatusRepositoryCommon_->GetCacheObjectIdsAndRevisionsByHash(ObjectIdOrHash_);
            for (const auto& cacheObject : cacheObjects) {
                *(event.add_cacheobjects()) = NLogEvent::TPodAgentCacheObject(
                    cacheObject.Id_
                    , cacheObject.Revision_
                );
            }

            event.set_objectidorhash(ObjectIdOrHash_);
            event.set_oldstate(GetStringFromState(oldState));
            event.set_newstate(GetStringFromState(State_));
            event.set_objecttype(GetObjectTypeFromEnum(StatusRepositoryCommon_->GetObjectType()));
            context.Get()->LogFrame.Get()->LogEvent(event);
        }

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
