#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/common.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_object_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackObjectStateNode;
using TFeedbackObjectStateNodePtr = TSimpleSharedPtr<TFeedbackObjectStateNode>;

class TFeedbackObjectStateNode : public TFeedbackObjectBasicNode {
public:
    TFeedbackObjectStateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , TStatusRepositoryCommon::TObjectState state
    )
        : TFeedbackObjectBasicNode(descriptor, statusRepositoryCommon, objectIdOrHash)
        , State_(state)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_OBJECT_STATE;

private:
    const TStatusRepositoryCommon::TObjectState State_;
};

} // namespace NInfra::NPodAgent
