#include "feedback_object_state_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestFeedbackObjectStateNode {

static TLogger logger({});

Y_UNIT_TEST_SUITE(FeedbackObjectStateNodeSuite) {

Y_UNIT_TEST(TestUpdateState) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";
    API::EWorkloadState state = API::EWorkloadState_ACTIVE;

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));

    TFeedbackObjectStateNodePtr node = new TFeedbackObjectStateNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
        , state
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
    API::TWorkloadStatus status = holder->GetObjectStatus(id);
    UNIT_ASSERT_EQUAL(state, status.state());
}

Y_UNIT_TEST(TestUpdateStateWithError) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";
    API::EWorkloadState state = API::EWorkloadState_ACTIVE;

    TFeedbackObjectStateNodePtr node = new TFeedbackObjectStateNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
        , state
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(!result, result.Success().Status);
    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "not found");
}

}

} // namespace NInfra::NPodAgent::NTestFeedbackObjectStateNode
