#include "feedback_object_verify_attempt_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackObjectVerifyAttemptNode::GetType() const {
    return TFeedbackObjectVerifyAttemptNode::NODE_TYPE;
}

TTickResult TFeedbackObjectVerifyAttemptNode::TickImpl(TTickContextPtr /*context*/) {
    try {
        StatusRepositoryCommon_->UpdateObjectVerifyAttempt(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
