#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_object_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackObjectVerifyAttemptNode;
using TFeedbackObjectVerifyAttemptNodePtr = TSimpleSharedPtr<TFeedbackObjectVerifyAttemptNode>;

class TFeedbackObjectVerifyAttemptNode : public TFeedbackObjectBasicNode {
public:
    TFeedbackObjectVerifyAttemptNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
    )
        : TFeedbackObjectBasicNode(descriptor, statusRepositoryCommon, objectIdOrHash)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_OBJECT_VERIFY_ATTEMPT;
};

} // namespace NInfra::NPodAgent
