#include "layer_keep_source_file_after_import_node.h"

namespace NInfra::NPodAgent {

ENodeType TLayerKeepSourceFileAfterImportNode::GetType() const {
    return TLayerKeepSourceFileAfterImportNode::NODE_TYPE;
}

TTickResult TLayerKeepSourceFileAfterImportNode::TickImpl(TTickContextPtr /* context */) {
    try {
        ui32 keepSourceFileAfterImportCounter = LayerStatusRepository_->GetObjectHashKeepSourceFileAfterImportCounter(LayerDownloadHash_);
        if (keepSourceFileAfterImportCounter > 0) {
            return TNodeSuccess(
                ENodeStatus::SUCCESS
                , TStringBuilder() << "KeepSourceFileAfterImportCounter = " << keepSourceFileAfterImportCounter
            );
        } else {
            return TNodeSuccess(
                ENodeStatus::FAILURE
            );
        }
    } catch (const yexception& e) {
        return TNodeError{
            TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()
        };
    }
}

} // namespace NInfra::NPodAgent
