#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_leaf.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/layer_status_repository.h>

namespace NInfra::NPodAgent {

class TLayerKeepSourceFileAfterImportNode;
using TLayerKeepSourceFileAfterImportNodePtr = TSimpleSharedPtr<TLayerKeepSourceFileAfterImportNode>;

class TLayerKeepSourceFileAfterImportNode : public TBasicLeaf {
public:
    TLayerKeepSourceFileAfterImportNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TLayerStatusRepositoryPtr layerStatusRepository
        , const TString& layerDownloadHash
    )
        : TBasicLeaf(descriptor)
        , LayerStatusRepository_(layerStatusRepository)
        , LayerDownloadHash_(layerDownloadHash)
    {
        Y_ENSURE(LayerStatusRepository_, "LayerStatusRepository not defined for TLayerKeepSourceFileAfterImportNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::LAYER_KEEP_SOURCE_FILE_AFTER_IMPORT;

private:
    const TLayerStatusRepositoryPtr LayerStatusRepository_;
    const TString LayerDownloadHash_;
};

} // namespace NInfra::NPodAgent
