#include "layer_keep_source_file_after_import_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestLayerKeepSourceFileAfterImportNode {

Y_UNIT_TEST_SUITE(LayerKeepSourceFileAfterImportNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestKeepSourceFileAfterImport) {
    TLayerStatusRepositoryPtr holder = new TLayerStatusRepository();
    const TString id = "my_layer";
    const TString hash = "my_layer_dowonload_hash";
    holder->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple(id, hash, 1, false));

    TLayerKeepSourceFileAfterImportNodePtr node = new TLayerKeepSourceFileAfterImportNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , hash
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, result.Success().Status);
    UNIT_ASSERT_EQUAL_C("KeepSourceFileAfterImportCounter = 1", result.Success().Message, result.Success().Message);
}

Y_UNIT_TEST(TestRemoveSourceFileAfterImport) {
    TLayerStatusRepositoryPtr holder = new TLayerStatusRepository();
    const TString id = "my_layer";
    const TString hash = "my_layer_dowonload_hash";
    holder->AddObject(NObjectMetaTestLib::CreateLayerMetaSimple(id, hash, 1, true));

    TLayerKeepSourceFileAfterImportNodePtr node = new TLayerKeepSourceFileAfterImportNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , hash
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    UNIT_ASSERT_EQUAL_C("", result.Success().Message, result.Success().Message);
}

Y_UNIT_TEST(TestNoDownloadHash) {
    TLayerStatusRepositoryPtr holder = new TLayerStatusRepository();
    const TString hash = "my_layer_dowonload_hash";

    TLayerKeepSourceFileAfterImportNodePtr node = new TLayerKeepSourceFileAfterImportNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , hash
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(!result, result.Success().Message);
}

}

} // namespace NInfra::NPodAgent::NTestLayerKeepSourceFileAfterImportNode
