#include "set_workload_was_destroyed_by_hook_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestSetWorkloadWasDestroyedByHookNode {

Y_UNIT_TEST_SUITE(SetWorkloadWasDestroyedByHookNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestSetWorkloadWasDestroyedByHook) {
    TWorkloadStatusRepositoryPtr statusRepository = new TWorkloadStatusRepository();
    const TString id = "my_workload";
    TWorkloadStatusRepositoryInternalPtr workloadStatusRepositoryInternal = new TWorkloadStatusRepositoryInternal();
    workloadStatusRepositoryInternal->AddObject(id);
    workloadStatusRepositoryInternal->UpdateObjectToBeDestroyedByHook(id, true);

    TSetWorkloadWasDestroyedByHookNodePtr node = new TSetWorkloadWasDestroyedByHookNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , statusRepository
        , workloadStatusRepositoryInternal
        , id
    );

    UNIT_ASSERT(workloadStatusRepositoryInternal->GetObjectShouldBeDestroyedByHook(id));
    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
    UNIT_ASSERT(!workloadStatusRepositoryInternal->GetObjectShouldBeDestroyedByHook(id));
}

}

} // namespace NInfra::NPodAgent::NTestSetWorkloadWasDestroyedByHookNode
