#include "static_resource_state_matches_node.h"

namespace NInfra::NPodAgent {

ENodeType TStaticResourceStateMatchesNode::GetType() const {
    return TStaticResourceStateMatchesNode::NODE_TYPE;
}

TTickResult TStaticResourceStateMatchesNode::TickImpl(TTickContextPtr /*context*/) {
    API::TStaticResourceStatus status;
    try {
        status = StaticResourceStatusRepository_->GetObjectHashStatus(StaticResourceDownloadHash_);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
    return status.state() == State_
        ? TNodeSuccess(ENodeStatus::SUCCESS)
        : TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "expected '" << API::EStaticResourceState_Name(State_) << "' got '" << API::EStaticResourceState_Name(status.state()) << "'");
}

} // namespace NInfra::NPodAgent
