#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_leaf.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/static_resource_status_repository.h>

namespace NInfra::NPodAgent {

class TStaticResourceStateMatchesNode;
using TStaticResourceStateMatchesNodePtr = TSimpleSharedPtr<TStaticResourceStateMatchesNode>;

class TStaticResourceStateMatchesNode : public TBasicLeaf {
public:
    TStaticResourceStateMatchesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStaticResourceStatusRepositoryPtr staticResourceStatusRepository
        , const TString& staticResourceDownloadHash
        , API::EStaticResourceState state
    )
        : TBasicLeaf(descriptor)
        , StaticResourceStatusRepository_(staticResourceStatusRepository)
        , StaticResourceDownloadHash_(staticResourceDownloadHash)
        , State_(state)
    {
        Y_ENSURE(StaticResourceStatusRepository_, "StaticResourceStatusRepository not defined for TStaticResourceStateMatchesNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::STATIC_RESOURCE_STATE_MATCHES;

private:
    const TStaticResourceStatusRepositoryPtr StaticResourceStatusRepository_;
    const TString StaticResourceDownloadHash_;
    const API::EStaticResourceState State_;
};

} // namespace NInfra::NPodAgent
