#include "static_resource_state_matches_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestStaticResourceStateMatchesNode {

Y_UNIT_TEST_SUITE(StaticResourceStateMatchesNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestUpdateStateMatches) {
    TStaticResourceStatusRepositoryPtr holder = new TStaticResourceStatusRepository();
    const TString id = "my_static_resource";
    const TString hash = "my_static_resource_dowonload_hash";
    holder->AddObject(NObjectMetaTestLib::CreateStaticResourceMetaSimple(id, hash));

    const API::EStaticResourceState state = API::EStaticResourceState_READY;
    holder->UpdateObjectState(hash, state);

    TStaticResourceStateMatchesNodePtr node = new TStaticResourceStateMatchesNode(TBasicTreeNodeDescriptor{1, "title"}, holder, hash, state);

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, result.Success().Status);
}

Y_UNIT_TEST(TestUpdateStateNotMatches) {
    TStaticResourceStatusRepositoryPtr holder = new TStaticResourceStatusRepository();
    const TString id = "my_static_resource";
    const TString hash = "my_static_resource_dowonload_hash";
    holder->AddObject(NObjectMetaTestLib::CreateStaticResourceMetaSimple(id, hash));

    const API::EStaticResourceState state = API::EStaticResourceState_READY;

    TStaticResourceStateMatchesNodePtr node = new TStaticResourceStateMatchesNode(TBasicTreeNodeDescriptor{1, "title"}, holder, hash, state);

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
}

}

} // namespace NInfra::NPodAgent::NTestStaticResourceStateMatchesNode
