#include "workload_clear_destroy_status_node.h"

namespace NInfra::NPodAgent {

ENodeType TWorkloadClearDestroyStatusNode::GetType() const {
    return TWorkloadClearDestroyStatusNode::NODE_TYPE;
}

TTickResult TWorkloadClearDestroyStatusNode::TickImpl(TTickContextPtr /*context*/) {
    try {
        WorkloadStatusRepository_->ClearDestroyStatus(WorkloadId_);
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{
            TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()
        };
    }
}

} // namespace NInfra::NPodAgent
