#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TWorkloadClearDestroyStatusNode;
using TWorkloadClearDestroyStatusNodePtr = TSimpleSharedPtr<TWorkloadClearDestroyStatusNode>;

class TWorkloadClearDestroyStatusNode : public TWorkloadBasicNode {
public:
    TWorkloadClearDestroyStatusNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
    )
        : TWorkloadBasicNode(descriptor, workloadStatusRepository, workloadId)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::WORKLOAD_CLEAR_DESTROY_STATUS;
};

} // namespace NInfra::NPodAgent
