#include "workload_clear_destroy_status_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestWorkloadClearDestroyStatusNode {

Y_UNIT_TEST_SUITE(WorkloadClearDestroyStatusNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestWorkloadClearDestroyStatus) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id, 1, 0, 0, true));

    NStatusRepositoryTypes::TContainerDescription destroyContainer(
        id
        , NStatusRepositoryTypes::EObjectType::WORKLOAD
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::DESTROY
    );
    holder->IncrementContainerSystemFailureCounter(destroyContainer);

    API::TDestroyStatus destroyStatus = holder->GetObjectStatus(id).destroy_status();
    UNIT_ASSERT(destroyStatus.has_destroy());
    UNIT_ASSERT_EQUAL_C(
        destroyStatus.container_status().system_failure_counter()
        , 1
        , destroyStatus.container_status().system_failure_counter()
    );

    TWorkloadClearDestroyStatusNodePtr node = new TWorkloadClearDestroyStatusNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());

    destroyStatus = holder->GetObjectStatus(id).destroy_status();
    UNIT_ASSERT(destroyStatus.has_destroy());
    UNIT_ASSERT_EQUAL_C(
        destroyStatus.container_status().system_failure_counter()
        , 0
        , destroyStatus.container_status().system_failure_counter()
    );
}

Y_UNIT_TEST(TestNoWorkload) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    TWorkloadClearDestroyStatusNodePtr node = new TWorkloadClearDestroyStatusNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_C(!result, result.Success().Message);
    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "not found at TWorkloadStatusRepository");
}

}

} // namespace NInfra::NPodAgent::NTestWorkloadClearDestroyStatusNode
