#include "workload_clear_stop_status_node.h"

namespace NInfra::NPodAgent {

ENodeType TWorkloadClearStopStatusNode::GetType() const {
    return TWorkloadClearStopStatusNode::NODE_TYPE;
}

TTickResult TWorkloadClearStopStatusNode::TickImpl(TTickContextPtr /*context*/) {
    try {
        WorkloadStatusRepository_->ClearStopStatus(WorkloadId_);
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{
            TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()
        };
    }
}

} // namespace NInfra::NPodAgent
