#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TWorkloadClearStopStatusNode;
using TWorkloadClearStopStatusNodePtr = TSimpleSharedPtr<TWorkloadClearStopStatusNode>;

class TWorkloadClearStopStatusNode : public TWorkloadBasicNode {
public:
    TWorkloadClearStopStatusNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
    )
        : TWorkloadBasicNode(descriptor, workloadStatusRepository, workloadId)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::WORKLOAD_CLEAR_STOP_STATUS;
};

} // namespace NInfra::NPodAgent
