#include "workload_clear_stop_status_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestWorkloadClearStopStatusNode {

Y_UNIT_TEST_SUITE(WorkloadClearStopStatusNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestWorkloadClearStopStatus) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id, 1, 0, 0, true));

    NStatusRepositoryTypes::TContainerDescription stopContainer(
        id
        , NStatusRepositoryTypes::EObjectType::WORKLOAD
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::STOP
    );
    holder->IncrementContainerSystemFailureCounter(stopContainer);

    API::TStopStatus stopStatus = holder->GetObjectStatus(id).stop_status();
    UNIT_ASSERT(stopStatus.has_stop());
    UNIT_ASSERT_EQUAL_C(
        stopStatus.container_status().system_failure_counter()
        , 1
        , stopStatus.container_status().system_failure_counter()
    );

    TWorkloadClearStopStatusNodePtr node = new TWorkloadClearStopStatusNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());

    stopStatus = holder->GetObjectStatus(id).stop_status();
    UNIT_ASSERT(stopStatus.has_stop());
    UNIT_ASSERT_EQUAL_C(
        stopStatus.container_status().system_failure_counter()
        , 0
        , stopStatus.container_status().system_failure_counter()
    );
}

Y_UNIT_TEST(TestNoWorkload) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    TWorkloadClearStopStatusNodePtr node = new TWorkloadClearStopStatusNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , id
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_C(!result, result.Success().Message);
    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "not found at TWorkloadStatusRepository");
}

}

} // namespace NInfra::NPodAgent::NTestWorkloadClearStopStatusNode
