#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository_internal/workload_status_repository_internal.h>

namespace NInfra::NPodAgent {

class TWorkloadShouldBeDestroyedByHookNode;
using TWorkloadShouldBeDestroyedByHookNodePtr = TSimpleSharedPtr<TWorkloadShouldBeDestroyedByHookNode>;

class TWorkloadShouldBeDestroyedByHookNode : public TWorkloadBasicNode {
public:
    TWorkloadShouldBeDestroyedByHookNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , TWorkloadStatusRepositoryInternalPtr workloadStatusRepositoryInternal
        , const TString& workloadId
    )
        : TWorkloadBasicNode(descriptor, workloadStatusRepository, workloadId)
        , WorkloadStatusRepositoryInternal_(workloadStatusRepositoryInternal)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::WORKLOAD_SHOULD_BE_DESTROYED_BY_HOOK;

private:
    TWorkloadStatusRepositoryInternalPtr WorkloadStatusRepositoryInternal_;
};

} // namespace NInfra::NPodAgent
