#include "workload_should_be_destroyed_by_hook_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestWorkloadShouldBeDestroyedByHookNode {

Y_UNIT_TEST_SUITE(WorkloadShouldBeDestroyedByHookNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestWorkloadShouldBeDestroyedByHookSuccess) {
    TWorkloadStatusRepositoryPtr statusRepository = new TWorkloadStatusRepository();
    const TString id = "my_workload";
    TWorkloadStatusRepositoryInternalPtr workloadStatusRepositoryInternal = new TWorkloadStatusRepositoryInternal();
    workloadStatusRepositoryInternal->AddObject(id);
    workloadStatusRepositoryInternal->UpdateObjectToBeDestroyedByHook(id, true);

    TWorkloadShouldBeDestroyedByHookNodePtr node = new TWorkloadShouldBeDestroyedByHookNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , statusRepository
        , workloadStatusRepositoryInternal
        , id
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
}

Y_UNIT_TEST(TestWorkloadShouldBeDestroyedByHookFailure) {
    TWorkloadStatusRepositoryPtr statusRepository = new TWorkloadStatusRepository();
    const TString id = "my_workload";
    TWorkloadStatusRepositoryInternalPtr workloadStatusRepositoryInternal = new TWorkloadStatusRepositoryInternal();
    workloadStatusRepositoryInternal->AddObject(id);

    TWorkloadShouldBeDestroyedByHookNodePtr node = new TWorkloadShouldBeDestroyedByHookNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , statusRepository
        , workloadStatusRepositoryInternal
        , id
    );

    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::FAILURE), result.Success());
}

}

} // namespace NInfra::NPodAgent::NTestWorkloadShouldBeDestroyedByHookNode
