#include "workload_target_active_node.h"

namespace NInfra::NPodAgent {

ENodeType TWorkloadTargetActiveNode::GetType() const {
    return TWorkloadTargetActiveNode::NODE_TYPE;
}

TTickResult TWorkloadTargetActiveNode::TickImpl(TTickContextPtr /*context*/) {
    if (UpdateHolderTarget_->WorkloadHasTarget(WorkloadId_)) {
        return TNodeSuccess(ENodeStatus::FAILURE, "Workload has new target revision");
    } else if (WorkloadStatusRepository_->GetObjectTargetState(WorkloadId_) == API::EWorkloadTarget_REMOVED) {
        return TNodeSuccess(ENodeStatus::FAILURE, "Workload has REMOVED target");
    } else {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    }
}

} // namespace NInfra::NPodAgent
