#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/update_holder/update_holder.h>

namespace NInfra::NPodAgent {

class TWorkloadTargetActiveNode;
using TWorkloadTargetActiveNodePtr = TSimpleSharedPtr<TWorkloadTargetActiveNode>;

class TWorkloadTargetActiveNode : public TWorkloadBasicNode {
public:
    TWorkloadTargetActiveNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , TUpdateHolderTargetPtr updateHolderTarget
        , const TString& workloadId
    )
        : TWorkloadBasicNode(descriptor, workloadStatusRepository, workloadId)
        , UpdateHolderTarget_(updateHolderTarget)
    {
        Y_ENSURE(UpdateHolderTarget_, "UpdateHolderTarget not defined for TWorkloadTargetActiveNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::WORKLOAD_TARGET_ACTIVE;

private:
    const TUpdateHolderTargetPtr UpdateHolderTarget_;
};

} // namespace NInfra::NPodAgent
