#include "workload_target_active_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/update_holder/test_lib/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestWorkloadTargetActiveNode {

Y_UNIT_TEST_SUITE(WorkloadTargetActiveNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestTargetActive) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));
    holder->UpdateObjectTargetState(id, API::EWorkloadTarget_ACTIVE);

    TWorkloadTargetActiveNodePtr node = new TWorkloadTargetActiveNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , updateHolder->GetUpdateHolderTarget()
        , id
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());
}

Y_UNIT_TEST(TestTargetNotActive) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));
    holder->UpdateObjectTargetState(id, API::EWorkloadTarget_REMOVED);

    TWorkloadTargetActiveNodePtr node = new TWorkloadTargetActiveNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , updateHolder->GetUpdateHolderTarget()
        , id
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(result.Success().Message, "Workload has REMOVED target");
    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
}

Y_UNIT_TEST(TestTargetActiveButChanged) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";

    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));
    holder->UpdateObjectTargetState(id, API::EWorkloadTarget_ACTIVE);
    updateHolder->SetWorkloadTarget(NObjectTargetTestLib::CreateWorkloadTargetSimple(id));

    TWorkloadTargetActiveNodePtr node = new TWorkloadTargetActiveNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , holder
        , updateHolder->GetUpdateHolderTarget()
        , id
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_C(result, result.Error().Message);
    UNIT_ASSERT_EQUAL(result.Success().Message, "Workload has new target revision");
    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
}

}

} // namespace NInfra::NPodAgent::NTestWorkloadTargetActiveNode
