#include "add_ip_address_node.h"

namespace NInfra::NPodAgent {

ENodeType TAddIpAddressNode::GetType() const {
    return TAddIpAddressNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TIpClientError>>, TTickResult> TAddIpAddressNode::IpClientCall(TTickContextPtr /*context*/) {
    return IpClient_->AddAddress(Device_, IpDescription_);
}

TTickResult TAddIpAddressNode::ProcessIpClientResult(TTickContextPtr /*context*/, TExpected<void, TIpClientError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(
            ENodeStatus::FAILURE
            , ToString(result.Error())
        );
    }
}

} // namespace NInfra::NPodAgent
