#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/ip_operations_basic_node.h>

namespace NInfra::NPodAgent {

class TAddIpAddressNode;
using TAddIpAddressNodePtr = TSimpleSharedPtr<TAddIpAddressNode>;

class TAddIpAddressNode : public TIpOperationsBasicNode<TExpected<void, TIpClientError>> {
public:
    TAddIpAddressNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncIpClientPtr ipClient
        , const TString& device
        , const TIpDescription& ipDescription
    )
        : TIpOperationsBasicNode(descriptor, ipClient)
        , Device_(device)
        , IpDescription_(ipDescription)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TIpClientError>>, TTickResult> IpClientCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessIpClientResult(TTickContextPtr context, TExpected<void, TIpClientError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::ADD_IP_ADDRESS;

private:
    const TString Device_;
    const TIpDescription IpDescription_;
};

} // namespace NInfra::NPodAgent
