#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/capture_status_basic_node.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

namespace NInfra::NPodAgent {

class TCaptureNetworkHookStatusNode;
using TCaptureNetworkHookStatusNodePtr = TSimpleSharedPtr<TCaptureNetworkHookStatusNode>;

class TCaptureNetworkHookStatusNode : public TCaptureStatusBasicNode<TExpected<void, TSystemLogsSenderError>> {
public:
    TCaptureNetworkHookStatusNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , ISystemLogsSenderPtr systemLogsSender
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , NStatusRepositoryTypes::EHookBackend hookBackend
    )
        : TCaptureStatusBasicNode(descriptor, systemLogsSender)
        , WorkloadStatusRepository_(workloadStatusRepository)
        , WorkloadId_(workloadId)
        , NetworkHookType_(networkHookType)
        , HookBackend_(hookBackend)
    {
        Y_ENSURE(WorkloadStatusRepository_, "WorkloadStatusRepository not defined for TCaptureNetworkHookStatusNode");
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::NO_HOOK, "NO_HOOK shouldn't be provided");
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::CONTAINER, "CONTAINER shouldn't be provided");
    }

    virtual ENodeType GetType() const override final;

//public for tests
public:
    NLogEvent::THttpAttemptFeedback CreateHttpLogEvent(const API::THttpGetStatus::TAttemptFeedback& httpFeedback);
    TString CreateHttpSystemLogMessage(const NLogEvent::THttpAttemptFeedback& httpEvent);

    NLogEvent::TTcpAttemptFeedback CreateTcpLogEvent(const API::TTcpCheckStatus::TAttemptFeedback& tcpFeedback);
    TString CreateTcpSystemLogMessage(const NLogEvent::TTcpAttemptFeedback& tcpEvent);

private:
    virtual TExpected<NThreading::TFuture<TExpected<void, TSystemLogsSenderError>>, TTickResult> CaptureStatus(TTickContextPtr context) override final;
    virtual TTickResult ProcessResult(TTickContextPtr context, TExpected<void, TSystemLogsSenderError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CAPTURE_NETWORK_HOOK_STATUS;

private:
    TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;
    const TString WorkloadId_;
    const NStatusRepositoryTypes::ENetworkHookType NetworkHookType_;
    const NStatusRepositoryTypes::EHookBackend HookBackend_;
};

} // namespace NInfra::NPodAgent
